using System;
using System.ComponentModel;
using System.Collections;
using System.Diagnostics;
using System.Windows.Forms;
using System.Drawing;

namespace gov.va.med.vbecs.GUI.controls
{
	/// <summary>
	/// Summary description for DataGridStatusColumn.
	/// </summary>
	public class DataGridStatusColumn : DataGridTextBoxColumn
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="container"></param>
		public DataGridStatusColumn(System.ComponentModel.IContainer container):this()
		{
			container.Add(this);
		}

		/// <summary>
		/// Constructor
		/// </summary>
		public DataGridStatusColumn()
		{
			InitializeComponent();

			this.Alignment = HorizontalAlignment.Center;
			this.ReadOnly = true;
			this.NullText = "";
		}

		/// <summary> 
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}


		#region Component Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			components = new System.ComponentModel.Container();
		}
		#endregion

		/// <summary>
		/// Paint
		/// </summary>
		/// <param name="g"></param>
		/// <param name="bounds"></param>
		/// <param name="source"></param>
		/// <param name="rowNum"></param>
		/// <param name="backBrush"></param>
		/// <param name="foreBrush"></param>
		/// <param name="alignToRight"></param>
		protected override void Paint(Graphics g, Rectangle bounds, CurrencyManager source, int rowNum, Brush backBrush, Brush foreBrush, bool alignToRight)
		{
			DataGrid grid = this.DataGridTableStyle.DataGrid;
			//
			if (bounds.X == 2)
			{
				switch (grid[rowNum, 0].ToString())
				{
					case "V":
						backBrush = Brushes.Lime;
						break;
					case "S":
						backBrush = Brushes.Lime;
						break;
					case "W":
						backBrush = Brushes.Yellow;
						break;
					case "E":
						backBrush = Brushes.Red;
						break;
					case "U":
						backBrush = Brushes.Red;
						break;
					default:
						break;
				}
			}
			//
			base.Paint(g, bounds, source, rowNum, backBrush, foreBrush, alignToRight);
		}


	}
}
